from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.ui import UISettings
from app.v1.services.platform import ui as ui_service

router = APIRouter()

@router.get("/", response_model=UISettings)
def get_settings(db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return ui_service.get_ui_settings(db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@router.post("/{account_id}", response_model=UISettings)
def update_settings(account_id: str, settings: UISettings, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return ui_service.update_ui_settings(account_id, settings.dict(), db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
